//+--------------------------------------------------------------------------------------------+
//|                                                                                            |
//|                                SonicR Chart Panel.mq4                                      | 
//|                                                                                            |
//+--------------------------------------------------------------------------------------------+ 
#property copyright "Copyright @ 2011 traderathome"
#property link      "email: traderathome@msn.com" 

/*---------------------------------------------------------------------------------------------
Overview:

The SonicR Chart Panel (White or Black).mq4 indicator incorporates a few changes from the
previous SonicR Chart Panel.mq4 indicator that was released 12/01/2010.  A list of the changes
can be found at the bottom of this overview.
 
This indicator places a colored panel in the upper left corner of the chart containing five 
labels: (1) the pair symbol and time frame, (2) the spread, (3) the range (average for the 
period selected, and current for the session), (4) the time to the next candle, and (5) the 
market bid price.  The "SonicR" logo appears in an extension panel to the right.

The indicator can be used for both forex and non-forex items. In the Forex mode, you can show 
either 4 digit or 5 digits.  If your platform is 4 digit and you select the 5 digit display, 
a "0" is added to displayed numbers. If it is a 5 digit platform and you select to display 4 
digits, numbers are rounded off to 4 digits, except for the Bid display.  The bid will not
increment/decrement until the next whole 4 digit number is reached. 

This indicator is a multi-function indicator.  It optionally charts: (1) a special bid line,
(2) a background of level lines that equally divide the distance between whole numbers into 
quarters, (3) the Daily Central Pivot line, (4) the Daily Suppport & Resistance lines, 
(5) average Range H/L target lines, (6) day separators, and (7) vertical lines marking the 
London Open, the New York Open and the London Close.

Optional Bid Ray Line-
You can select to place your own Bid Ray Line on the chart, which you can vary in thickness 
and color.  The Bid Ray Line ends at the current candle, or at your specified number of TFs 
beyond.  It terminates with a Bid Dot that can be sized and that changes color(grn/red) as 
the bid price changes(up/dn).   To display only your own Bid Ray Line, right click on the 
chart, select Chart Properties/Colors and make the Grid color = "None".  Otherwise, the MT4 
bid line is beneath your own, and visible from the end of your line to the chart edge.

Optional Level Lines-
This indicator places level lines on your chart at key levels between whole numbers (00, 25, 
50, 75 and 00 again).  The number of "sets" of these lines above and below the current price 
range "set" is determined by hard code.  But "Override_Line_Sets_Displayed" allows for change.  
For example, if "1" is entered, then one set of lines is displayed for the current range.  If 
"2" is entered, then one set of lines is displayed for the current range and a second set is 
displayed both above and below the current range.  An input of "0" or less will default to the 
hard code.  The lines can individually be of any available color and style and thickness. 
Line catagories other than whole number can be turned On/Off individually while the other 
catagories remain displayed.

Optional Daily Pivot Line-
You can select to display the DPV line, which is actually constructed using two lines.  One 
is a wide background line of a highlighting color (Example: Yellow) and the other is a narrow 
top line of a darker color (Example: Black).  You have your choice of line colors, styles and 
thickness (for solid lines).

Optional Daily Support & Resistance Lines-
You can select to display the DSR lines, which are extended to include five levels instead of
the usual three levels.  You have your choice of line colors, styles and thickness (for solid
lines).

Optional Range High/Low Lines-
You can select to display two horizontal lines, one for the computed range high target for the
current session, and the other for the computed range low target for the current session.  The
computed range is based on an averaging period you select (default = 14 days).  The range
averaging process eliminates brief Sunday sessions, replacing them with another full session
day.  So, no matter the averaging period, there are no short Sunday sessions to drag the average
down, and no days missing from the averaging process.  You have your choice of line colors, 
styles and thickness (for solid lines).

The optional range H/L lines are displayed in two different ways, according to two different
conditions.  Condition #1 is that the session range has not exceeded the computed average
range.  The RgH line is the computed average range distance above the session Low, and the
RgL line is the computed average range distance below the session high.  The lines will move
as new highs/lows are achieved during the session.  This display shows how far price can move 
in either direction before exceeding the computed average range.  Condition #2 occurs if PA 
exceeds the computed average range.  Then, if price is in the upper half of the new increased 
range the RgL line is at the session low and the RgH line is at the computed average range 
distance above the RgL line.  And if price is in the lower half of the new increased range the 
RgH line is at the session high and the RgL line is at the computed average range distance 
below RgH line.  This display shows the relationship between the computed average range limit
and the current session PA (Price Activity), which has moved beyond that limit.

Displaying Horizontal Lines-
The horizontal line groups can be displayed differently, one from another, using display
numbers 0-4.  The horizontal line groups are: whole number Levels, half number Levels, 
quarter number Levels, the Daily central pivot, Daily S&R pivots, and Range H/L Targets.  
"0" draws the lines across the chart.  "1" draws the lines from chart left thru the current
session.  "2" draws the lines only thru the current session.  "3" draws the lines from the 
start of the current session to chart right.  "4" draws the lines from the current candle
to chart right.  And this last option allows you to shift the start of the lines further 
away from the current candle using the input "Display_4_Shift_Right".  The feature to start
lines further right from the current candle begins lines at a specific time in the future 
based on the number (of TFs) you input to "Display_4_Shift_Right".  If you are using a 
chart with the standard chart zoom and you input "46" (TFs) to shift lines to the right, 
and then you zoom in 1 step, the lines may disappear because they start too far into the 
future to be seen on the wider candle chart!  To make the lines start in about the same 
location relative to the right chart border on both charts, a lower number would need to be 
used for the wider candle chart.  Notes in the External Inputs provide sample numbers that 
start lines at an equivalent distance in from the right chart border for the various chart 
zoom settings.  

Optional Separators-
You can apply day separators to your chart with this option that lets you select color and 
line styles. 

Optional Vertical Time Lines-
You can select to display vertical time lines for the London Open, New York Open and London
Close.  Setting up the times for these vertical lines is more fully commented on as follows.
 
The vertical lines are set by default for a broker/server based upon the GMT time zone, which 
would have a GMT setting of "0" and a DST setting of "2".  For any other broker/server that
is not GMT bassed, you must go thru the following steps to properly determine these two 
important inputs.  1) What is your broker/server "DST_Server_GMT_Offset" in +/- hours?  In 
other words, during the DST (summer) time of the year, your broker server charts are based on 
a time that is how many hours before or after GMT?  And 2) What is your broker server 
"DST_Zone"?  In other words, when does the broker server make the twice yearly DST changes.  
Does the broker server make the changes the same time as does US, EU, AUS, NZ?  Or does the 
broker server make the changes some other time (which will require you to make a customized 
"DST_Zone")?  Previously reported GMT and DST inputs by users for various broker servers are 
shown in "Suggested GMT/DST Settings:" below.  They are not guaranteed, so you should proceed 
as follows.  Once you have validated the GMT and DST settings for your brokerserver, please 
post them on the SonicR thread, so the "Suggested GMT/DST Settings:" section can be confirmed 
and expanded.  Thank you.

1. Getting your "GMT" number...
If your broker/server is at GMT time all year, then your "DST_Server_GMT_Offset" is zero.
Otherwise, determine your "DST_Server_GMT_Offset" by using the SonicR Clock Panel.  Set it
to display in 24 hour format, showing "GMT" and "Broker".  If it is during the DST time of
year that you are setting this up, the hours difference (+/-) between "Broker" and "GMT" is 
your "DST_Server_GMT_Offset".  If it is the non-DST time of year that you are setting this up, 
then add one hour to the difference.  For example, London is at GMT+1 during DST, but during
the non-DST time of year London is at GMT+0. So, if you were setting this up during the
non-DST time of year you would add "+1" to the zero difference to get the proper input "1"
required for the "DST_Server_GMT_Offset". 

2. Getting your "DST" number...
Four DST zones are preset for you to choose from (US, EU, AUS and NZ), hard coded to make an
hour shift for DST changeovers at the appropriate time twice yearly.  If your broker does not
implement DST changeovers on their server when one of these 4 zones implement DST changeovers,
then you must customize a 5th DST zone based on when your broker does make DST changeovers.  
Do not assume that your broker server is in a zone just because the chart time scale is 
based on time in the zone, or because the broker is located in the zone.  You must find out 
from your broker if they make their DST changes on their server per one of the four choices,
or not.  If they do not, then you need to get the exact times (Month, day, hour) that they 
do implement their DST changes twice yearly on their server.

Enter the number 1, 2, 3 or 4 for the DST zone that coincides with when your broker makes the 
DST changeovers on its server.  If your broker makes DST changeovers not coinciding with any 
of these DST zones, enter "5" and proceed to customize a 5th DST zone accordingly.

To customize your DST Zone settings just follow the instructions provided by Caveman in the 
External Inputs Window.  You are to input the correct Month, which Sunday of the Month, and 
at what hour (24 hour format) your broker/server starts DST.  And repeat the same information 
for when your broker/server ends DST.  If you do not know when these times are, obtain this 
information from your broker.

Additional Remarks on displaying market open vLines-
Here is some "background" information that helps to explain what is going on.  The location
of the vLines is determined by the number of hours these events occur after the session start,
per your broker/server time.  For example, if the London Open starts 7 hours into the broker 
server day, then you would enter "7" for the London_Open_Time.  If the New Your Open starts 
5 hours later, you would enter "12" for the NewYork_Open_Time.  In other words, all times are
based on when your broker/server day starts, and when during that day the individual events
occur.  From this, you can easily understand that for broker/servers in different time zones,
the hours to input for the various events will be different.  It is somewhat simplified by
defaulting to hours appropriate to a GMT based broker/server and then using the user's actual
broker/server GMT offset, together with CaveMan's DST code, to automatically make the twice
yearly necessary changes.

Some servers/brokers have a very brief Sunday session.  This causes some or all of the vlines
for that session to "stack" up.  When the next session starts, the new current session vlines 
will display properly, but the vlines for that brief previous session will still be "stacked".   
There is no known easy coding solution available. 

A final note on the vertical lines (vlines) settings.  They can be set to 1/2 hour times.
To do this simply add ".5" to the number.  Only whole hour inputs, or whole hour and a half
inputs will result in properly placed lines.

List of Changes From 12/01/2010 Release To Current Release:
01 - removes default colors coding (new indicators for "White" and "Black" charts) 
02 - Removes "masking" of chart OHLC display since it is defeated in some versions of MT4     
03 - corrects Panel Bid to display mathfloor of Bid when not in 5-digit mode
04 - rewrite of Price label code    
05 - add variable configuration feature for special Bid line and simplify code
06 - delete Small & Medium Panels, and make Large Panel slightly smaller than before
07 - add pricing feature to labels 
08 - add a new line display configuration from left chart border thru current session
09 - add "+Shift Right" feature for line display #4, with sample numbers   
10 - add Broker server Daily pivots, with line highlighting code for DPV.
11 - recode Levels to allow full display choices, and remove 1/8 line code 
11 - recode to assure Pivots on top of Levels when they coincide
12 - expand horizontal line group catagores        
13 - recode to permit horizontal line groups to be displayed differently         
14 - alter some colors, particularly for black charts         
15 - reduce vLines code to just London Open, NY Open, and London Close
16 - expand DST code to automate/accomodate the 3 DST changeovers affecting vLines
     A. when London implements DST changeovers the London vLines shift appropriately
     B. when NY implements DST changeovers the NY vLine shifts appropriately
     C. when users broker/server implements DST changeovers the vLines shift appropriately                    

                                                                    - Traderathome, 05-15-2011                                                                    
------------------------------------------------------------------------------------------------
Acknowlegements:
CaveMan - who generously devoted his time and programming skills to create his benchmark DST 
          code which automates applying an hour time shift as appropriate due to DST/non-DST
          changes, and provides for customizing your own DST_Zone setting in case the times of
          your broker/server DST/non-DST changes is not covered by the preconfigured DST zones.     
Domas4  - "THANKS!" are owed to Domas4 for providing price labeling code compatible with non-
          forex items. 

------------------------------------------------------------------------------------------------
Suggested Settings:          White Chart              Black Chart 
        
Panel_Background_Color       C'233,233,252'           C'18,18,18'
Symbol_And_TF_Color          Black                    C'208,208,208'
Spread_Color                 Black                    C'150,150,150'
Range_Color                  Black                    C'150,150,150'
Candle_Time_Color            Black                    C'150,150,150'
PriceLabel_UP_Color          ForestGreen              C'46,188,46'
PriceLabel_DOWN_Color        Crimson                  C'234,0,0'
sonicS                       C'44,44,255'             C'0,121,230'
sonicM                       Black                    LightGray
sonicR                       Red                      Red
Bid_Ray_Color                Black                    Gray 
Bid_Dot_Up_Color             LimeGreen                Lime
Bid_Dot_Dn_Color             OrangeRed                Red  
Whole_Number_Color           Lavender                 C'41,33,73'         
Half_Number_Color            C'207,250,207'           C'0,53,0'             
Quarter_Number_Color         C'242,238,227'           C'54,40,24'                                                 
DPV1_Background_Color        Yellow                   C'230,216,0' 
DPV2_Top_Color               Black                    Black  
Resistance_Pivots_Color      Tomato                   C'179,0,0'  
Support_Pivots_Color         C'64,64,255'             C'90,75,173'         
RangeHigh_Color              Tomato                   Red
RangeLow_Color               C'106,106,255'           C'0,115,230'
Pivot_Range_Labels_Color     MidnightBlue             DarkGray  
Separators_Color             Silver                   C'88,88,0'   
vLines_Color                 Silver                   C'74,74,0'                      
vLabels_Color                BlueViolet               Olive


Suggested GMT/DST Settings:          GMT              DST

Alpari UK                             2                2
DivisaFX                              0                2
E Global                              2                2
FXDD                                  3                1
GoMarkets                             0                2
InterBankFX                           1                2
MBT                                  -4                1

These GMT/DST settings have been reported by users.  You should follow the steps outlined in 
the user notes to get your GMT and DST inputs.  Please post on the SonicR thread the proper
settings for your broker/server so that this list might be confirmed and expanded.  Thank you.                                                                                                                                                    
----------------------------------------------------------------------------------------------*/


//+--------------------------------------------------------------------------------------------+
//| Indicator Global Inputs                                                                    |                                                        
//+--------------------------------------------------------------------------------------------+ 
#property indicator_chart_window

//Global External Inputs------------------------------------------------------------------------ 
extern string Part_1                          = "Indicator Master Controls:";
extern bool   Indicator_On                    = true;
extern bool   Main_Panel_On                   = false;
extern bool   __SonicR_Logo_On                = false;
extern int    Main_Panel_Max_TF               = 43200;
extern bool   Bid_Line_On                     = false;
extern bool   Levels_On                       = true;
extern int    Levels_Max_TF                   = 240;
extern bool   Pivots_DPV_Line_On              = true;
extern bool   Pivots_DSR_Lines_On             = true;
extern bool   Range_Lines_On                  = true; 
extern int    Pivots_Range_Lines_Max_TF       = 240;
extern bool   Separators_On                   = true;
extern int    Separators_Max_TF               = 240;
extern bool   vLines_On                       = true;
extern int    vLines_Max_TF                   = 60;
extern int    DST_Server_GMT_Offset           = 0;
extern string TF_Choices_1                    = "M1 - H4 =  1, 5, 15, 30, 60, 240";
extern string TF_Choices_2                    = "D  W  M =  1440,  10080,  43200";

extern string __                              = "";
extern string Part_2                          = "Chart Panel Settings:";
extern bool   Use_For_Forex                   = true;
extern bool   Display_5_Digits_Forex          = false;
extern int    Digits_To_Show_In_Spread        = 2;
extern color  Panel_Background_Color          = C'233,233,252';
extern color  Symbol_And_TF_Color             = Black; 
extern color  Spread_Color                    = Black;
extern int    Days_For_Range_Average          = 14;  
extern color  Range_Color                     = Black;
extern color  Candle_Time_Color               = Black;
extern color  PriceLabel_UP_Color             = ForestGreen;
extern color  PriceLabel_DOWN_Color           = Crimson;
extern color  sonicS                          = C'44,44,255';
extern color  sonicM                          = Black;
extern color  sonicR                          = Red;

extern string ___                             = "";
extern string Part_3                          = "Bid Ray Line Settings:";
extern color  Bid_Ray_Color                   = Black;
extern int    Bid_Ray_LineStyle_01234         = 0;  
extern int    Bid_Ray_Thickness               = 2;
extern int    Bid_Ray_TFs_Past_Last_Candle    = 4;
extern color  Bid_Dot_Up_Color                = Lime;
extern color  Bid_Dot_Dn_Color                = OrangeRed;     
extern int    Bid_Dot_Size                    = 10;

extern string ____                            = "";
extern string Part_4                          = "Horizontal Lines Position Settings:";
extern string note0                           = "0 = Full screen";
extern string note1                           = "1 = left thru current session";
extern string note2                           = "2 = Current session only";
extern string note3                           = "3 = Current session to right";
extern string note4                           = "4 = Last candle to right (+Shift_Right)";
extern int    Level_Wholes_Display_Number     = 2;
extern int    Level_Halves_Display_Number     = 2;
extern int    Level_Quarters_Display_Number   = 2;
extern int    Daily_PV_Line_Display_Number    = 2;
extern int    Daily_RS_Lines_Display_Number   = 2;
extern int    Range_Lines_Display_Number      = 2;
extern string note5                           = "Sample equivalent '+Shift_Right'";
extern string note6                           = "numbers for Display Number 4:";
extern string note7                           = "Zoom out 2 = 190, 148";
extern string note8                           = "Zoom out 1 = 90, 75";
extern string note9                           = "Std. chart = 46, 38";
extern string note10                          = "Zoom in 1  = 24, 20";
extern string note11                          = "Zoom in 2  = 13, 11";
extern string note12                          = "Zoom in 3  = 7, 6";
extern int    Display_4_Shift_Right           = 46;

extern string _____                           = "";
extern string Part_5                          = "Levels Settings:";
extern int    Override_Line_Sets_Displayed    = 0;
extern bool   Half_Number_Lines_On            = true;
extern bool   Quarter_Number_Lines_On         = true;
extern color  Whole_Number_Color              = Lavender;  
extern int    Line1_Style_01234               = 0;
extern int    Line1_SolidThickness            = 3;
extern color  Half_Number_Color               = C'207,250,207'; 
extern int    Line2_Style_01234               = 0;
extern int    Line2_SolidThickness            = 2;
extern color  Quarter_Number_Color            = C'242,238,227';   
extern int    Line3_Style_01234               = 0;
extern int    Line3_SolidThickness            = 2;

extern string ______                          = "";
extern string Part_6                          = "Pivot Lines Settings:"; 
extern color  DPV1_Background_Color           = Yellow;
extern int    DPV1_LineStyle_01234            = 0;
extern int    DPV1_SolidLineThickness         = 3; 
extern color  DPV2_Top_Color                  = Gray;
extern int    DPV2_LineStyle_01234            = 0;
extern int    DPV2_SolidLineThickness         = 1; 
extern color  Resistance_Pivots_Color         = Tomato; 
extern int    R_LineStyle_01234               = 0;
extern int    R_SolidLineThickness            = 1; 
extern color  Support_Pivots_Color            = C'64,64,255';
extern int    S_LineStyle_01234               = 0;
extern int    S_SolidLineThickness            = 1; 

extern string _______                         = "";
extern string Part_7                          = "Range Lines Settings:"; 
extern color  RangeHigh_Color                 = Tomato;
extern color  RangeLow_Color                  = C'106,106,255';
extern int    RG_LineStyle_01234              = 0;    
extern int    RG_SolidLineThickness           = 3;

extern string ________                        = "";
extern string Part_8                          = "Pivot & Range Labels Settings:";
extern color  Pivot_Range_Labels_Color        = MidnightBlue;
extern bool   DPV_Label_Shown                 = true;
extern bool   DSR_Labels_Shown                = true;
extern bool   RG_Labels_Shown                 = true;
extern bool   Pivot_Range_Labels_Prices       = false;
extern string Pivot_Range_Labels_FontStyle    = "Verdana"; 
extern int    Pivot_Range_Labels_FontSize     = 8;  
extern bool   Pivot_Range_Labels_MaxRight     = false;

extern string _________                       = "";
extern string Part_9                          = "Separators Selections:";
extern color  Separators_Color                = Silver;  
extern int    Separators_Style_01234          = 2;    
extern int    Separators_Solid_Thickness      = 1;
extern bool   Separators_Thru_SubWindows      = true;
extern int    Prior_Days_To_Show_Separators   = 0;

extern string __________                      = "";
extern string Part_10                         = "vLines Selections:";
extern color  vLines_Color                    = Silver; 
extern int    vLines_Style_01234              = 2;    
extern int    vLines_Solid_Thickness          = 1;
extern bool   vLines_Thru_SubWindows          = true;
extern bool   vLines_Current_Session_On       = true;
extern int    vLines_Prior_Sessions_To_Show   = 0;

extern string ___________                     = "";
extern string Part_11                         = "vLabels Settings:";
extern color  vLabels_Color                   = BlueViolet; 
extern string vLabels_FontStyle               = "Verdana Bold";
extern int    vLabels_FontSize                = 8;
extern bool   vLabels_Chart_Top               = true;
extern int    vLabels_Dist_To_Border          = 1;
extern string Label_London_Open               = "      Lo";
extern string Label_NewYork_Open              = "    N";
extern string Label_London_Close              = "      Lc";

// Start - Added by CaveMan to cater for DST
extern string ____________                    = "";
extern string Part_12                         = "DST Zone Settings:";
extern string note_1                          = "Enter preset DST zone number 1 - 4";
extern string note_2                          = "or enter ' 5 ' for a custom DST zone.";
extern string note_3                          = "1 US   2 EU   3 AUS   4 NZ   5 Cust.";
extern int    DST_Zone                        = 2;
extern string note_4                          = "To customized A DST setting -";  
extern string note_5                          = "Enter # month DST starts,";
extern int    Custom_DST_Start_Month          = 3; //March
extern string note_6                          = "Enter # Sunday DST starts,";
extern string note_7                          = "1-1st Sunday, 2-2nd ....7-Last Sunday";
extern int    Custom_DST_Start_Sunday         = 2; //2nd Sunday of March start DST
extern string note_8                          = "Enter 24 hour time DST starts,";
extern string Custom_DST_Start_Time           = "02:00"; //DST starting time
extern string note_9                          = "Repeat for DST end,";
extern int    Custom_DST_End_Month            = 11; //November
extern int    Custom_DST_End_Sunday           = 1;  //1st Sunday of November end DST
extern string Custom_DST_End_Time             = "02:00"; //DST ending time
// End - Added by CaveMan to cater for DST


//Buffers, Constants and Variables-------------------------------------------------------------
bool       FLAG_deinit;

//Deinit Section
int        obj_total,k;
string     name;

//Chart Panel
color      Static_Price_Color, Static_Bid_Color, Bid_Dot_Color, Static_Bid_Dot_Color;
int        fxDigits,modifier,Color,Factor,h,i, m,s,t,T1,T2;
int        p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12,p13,p14,p15;
int        p21,p22,p23,p24,p25,p26,p27,p28,p29,p30,p31,p32,p33;
double     Poin, PoinFx, Old_Price, fxPrice, level, Spread, ARg, Range, TodayRange;  
string     item1  = "[Chart Panel] Box 2";  
string     item2  = "[Chart Panel] Box 3"; 
string     item3  = "[Chart Panel] Box 4";
string     item4  = "[Chart Panel] Box 5";
string     item6  = "[Chart Panel] ID&TF";
string     item7  = "[Chart Panel] Spread"; 
string     item8  = "[Chart Panel] Range";     
string     item9  = "[Chart Panel] Time"; 
string     item10 = "[Chart Panel] Price";
string     item11 = "[Chart Panel] Logo1 S"; 
string     item12 = "[Chart Panel] Logo1 o"; 
string     item13 = "[Chart Panel] Logo1 n";     
string     item14 = "[Chart Panel] Logo1 i"; 
string     item15 = "[Chart Panel] Logo1 c";
string     item16 = "[Chart Panel] Logo1 R"; 
string     item17 = "[Chart Panel] Bid Line";
string     item18 = "[Chart Panel] Bid Dot";
string     sub1,sub2,Price,C,G,tab,tab2,timeleft; 

//Levels Section
color      linecolor;
double     linelevel, linestyle, linewidth, BL;
int        j, Z;
int        Line1_Color, Line2_Color, Line3_Color;
int        u1=00, u2=50, u3=25, u4=75;        
int        c1, ssp, ssp1, NumberOfRanges;
string     linename;

//Range Section of Panel
int        ii,iii,x,xx,r,TodayBar;
double     HiToday,LoToday,startToday,endToday;
double     YesterdayBar, YesterdayHigh, YesterdayLow, YesterdayClose, Pivot;
double     RangeAvg, RangeHigh, RangeLow, RH, RL;
double     r1,r2,r3,r4,r5, s1,s2,s3,s4,s5; 

//Draw Lines
int        a,b,c,R2,T,T4;  
string     line, dt;
datetime   startline, stopline;

//Draw Labels
string     linelabel, spc;
datetime   startlabel, startrangeday; 

//vLines Section
int        bps, MF,time3;
datetime   shift, T3;
double     top, bottom, scale,YadjustTop,YadjustBot,time2,time4;
string     vline,vlabel;
string     Label_Day_Separator = "day";
static int Day_Start_Time = 0;
static int Day_End_Time   = 24;
double     GMT_At_DST_London_Open_Time     = 7;    
double     GMT_At_NewYork_Open_Time        = 12;   
double     GMT_At_London_Close_Time        = 16;  

//GMT & DST - Added by CaveMan/modified by Traderathome
int        NonDST_Server_GMToffset, Current_Server_GMToffset, LastRefresh, First_Time;
int        LondonDSTshift, NewYorkDSTshift; 

//+-------------------------------------------------------------------------------------------+
//| Indicator Initialization                                                                  |                                                        
//+-------------------------------------------------------------------------------------------+      
int init()
   {
   //If one, or both, Range Line settings are invalid, exit------------------------------------
   if (Level_Wholes_Display_Number <0 || Level_Wholes_Display_Number >4 ||
      Level_Halves_Display_Number <0 || Level_Halves_Display_Number >4 ||
      Level_Quarters_Display_Number <0 || Level_Quarters_Display_Number >4 ||
      Daily_PV_Line_Display_Number <0 || Daily_PV_Line_Display_Number >4 ||        
      Daily_RS_Lines_Display_Number <0 || Daily_RS_Lines_Display_Number >4 ||
      Range_Lines_Display_Number <0 || Range_Lines_Display_Number >4)         
      {
      Alert("SonicR Chart Panel: Range/SR Line Number invalid"); return(false);
      }   
   
   FLAG_deinit = false;
   
   //GMT & DST - Added by CaveMan/modified by TAH
   if (DST_Server_GMT_Offset != 0) {NonDST_Server_GMToffset = DST_Server_GMT_Offset - 1;} 
   else {NonDST_Server_GMToffset = 0;}
   LastRefresh = TimeHour(iTime(NULL,0,0));
   First_Time = true;       
                
   //Chart Panel - setting vertical & horizontal positions of borders and text   
   G= "g";
   p1= 69; p2= 138; p3= 141; p4= 143; p5= 63; p6= 157; p7= 49; p8= 168; p9= 38;
   p10= 182; p11= 28; p12= 190; p13= 16; p14= 201; p15= 1; 
   p21= 69; p22= 46; p23= 2; p24= 21; p25= 19; p26= 21; p27= 33; p28= 21; p29= 47;
   p30= 5; p31= 61; p32= 9; p33= 18;
      
        
   //Chart Panel - determine display of Market Price
   if (Use_For_Forex)
      {
      sub1=StringSubstr(Symbol(), 3, 3);
      sub2=StringSubstr(Symbol(), 0, 2);
      if (Display_5_Digits_Forex) 
         {
         fxDigits = 5;
         if (sub1 == "JPY") {fxDigits = 3;} 
         if (sub2 == "XA")  {fxDigits = 2;}
         }        
      else 
         {
         fxDigits = 4;
         if (sub1 == "JPY") {fxDigits = 2;}
         if (sub2 == "XA")  {fxDigits = 2;} 
         }         
      } 
   if (Digits == 5 || Digits == 3) {Factor = 10;} 
   else {Factor = 1;} //cater for 5 digits 
    
   //Chart Panel and Levels - Check for unconventional Point digits number for display of market price
   if (Point == 0.00001) {Poin = 0.0001;} //5 digits     
   else if (Point == 0.001) {Poin = 0.01;} //3 digits
   else {Poin = Point;} //Normal 4 digits
   if (Symbol() == "XAUUSD") {Poin = 0.1;}  
   
   //Levels - set ranges to user specified #, or use a preset number
   if ((Levels_On) && (Override_Line_Sets_Displayed >= 1)) 
      {
      NumberOfRanges = Override_Line_Sets_Displayed-1;
      }   
   else if(Period() == 1) {NumberOfRanges = 4;}
   else if(Period() == 5) {NumberOfRanges = 7;}
   else if(Period() == 15) {NumberOfRanges = 10;}
   else if(Period() == 30) {NumberOfRanges = 10;}   
   else if(Period() == 60) {NumberOfRanges = 10;}  
   else if(Period() == 240) {NumberOfRanges = 20;}  
   else if(Period() == 1440) {NumberOfRanges = 30;} 

   return(0);
   }

//+-------------------------------------------------------------------------------------------+
//| Indicator De-initialization                                                               |                                                        
//+-------------------------------------------------------------------------------------------+       
int deinit()
   {   
   obj_total= ObjectsTotal();  
   for (k= obj_total; k>=0; k--)
      {
      name= ObjectName(k); 
      if (StringSubstr(name,0,13)=="[Chart Panel]"){ObjectDelete(name);}
      }
   //Comment ("");
   return(0);
   }

//+-------------------------------------------------------------------------------------------+
//| Indicator Start                                                                           |                                                        
//+-------------------------------------------------------------------------------------------+         
int start()
   {
   //If Indicator is "Off" deinitialize only once, not every tick------------------------------  
   if (!Indicator_On) 
      {
      if (!FLAG_deinit) {deinit(); FLAG_deinit = true;}
      return(0);
      }
            
   //If indicator is "ON", deinitialize and run------------------------------------------------ 
   deinit(); FLAG_deinit = false; 

   //Panel and Range lines - Define today's bar/data                   
   TodayBar   = iBarShift(NULL,PERIOD_D1,Time[0]);
   HiToday    = iHigh (NULL,PERIOD_D1,TodayBar);
   LoToday    = iLow  (NULL,PERIOD_D1,TodayBar); 
   TodayRange = ((HiToday - LoToday)/Point)/Factor; 
   
   //Panel and S&R - 
   //The color is to remain as-is until price changes direction by a whole pip, or by a fractional
   //pip if 5 digits is displayed.  We don't want a 3rd color on ticks without a price change.
   if (Use_For_Forex)
      {  
      if (Display_5_Digits_Forex) {fxPrice = Bid;}        
      else 
         {
         PoinFx = Poin;         
         if (sub2 == "XA") {PoinFx = 0.01;}
         fxPrice = MathFloor(Bid/PoinFx)*PoinFx;
         }          
      Price=DoubleToStr(fxPrice, fxDigits);
      }      
   else 
      {
      fxPrice = Bid;
      Price=DoubleToStr(Bid, Digits);
      } 
                 
   if (fxPrice > Old_Price) 
      {
      Color = PriceLabel_UP_Color;
      Static_Price_Color = Color;     
      Bid_Dot_Color = Bid_Dot_Up_Color;       
      Static_Bid_Dot_Color = Bid_Dot_Up_Color;   
      }
   else if (fxPrice < Old_Price) 
      {      
      Color = PriceLabel_DOWN_Color; 
      Static_Price_Color = Color;  
      Bid_Dot_Color = Bid_Dot_Dn_Color;  
      Static_Bid_Dot_Color = Bid_Dot_Dn_Color;  
      }   
   else //if (fxPrice == Old_Price)  
      {
      Color = Static_Price_Color;       
      Bid_Dot_Color = Static_Bid_Dot_Color;
      }
   Old_Price = fxPrice;
      
   //Main Panel
   if ((Main_Panel_On) && (Period()<= Main_Panel_Max_TF)) {      
   //Create Chart Main Panel Background boxes      
   ObjectCreate(item1, OBJ_LABEL, 0, 0, 0, 0, 0);
   ObjectSetText(item1, G, p21, "Webdings");
   ObjectSet(item1, OBJPROP_CORNER, 0);
   ObjectSet(item1, OBJPROP_XDISTANCE, 0);
   ObjectSet(item1, OBJPROP_YDISTANCE, 0);   
   ObjectSet(item1, OBJPROP_COLOR, Panel_Background_Color);
   ObjectSet(item1, OBJPROP_BACK, false);     
   //-----         
   ObjectCreate(item2, OBJ_LABEL, 0, 0, 0, 0, 0);
   ObjectSetText(item2, "g", p21, "Webdings");
   ObjectSet(item2, OBJPROP_CORNER, 0);
   ObjectSet(item2, OBJPROP_XDISTANCE, p22);//52
   ObjectSet(item2, OBJPROP_YDISTANCE, 0);   
   ObjectSet(item2, OBJPROP_COLOR, Panel_Background_Color);
   ObjectSet(item2, OBJPROP_BACK, false);  
         
   //Symbol and Time Frame   	 	         
   C= " "; if (Period()== 1)  C =C +  "     "+Symbol()+"   M1";
      else {if (Period()== 5)  C =C +  "     "+Symbol()+"   M5";
      else {if (Period()== 15) C =C +  "    "+Symbol()+"   M15";
      else {if (Period()== 30)  C =C +  "    "+Symbol()+"   M30";
      else {if (Period()== 60)  C =C +  "     "+Symbol()+"   H1";
      else {if (Period()== 240)  C =C +  "     "+Symbol()+"   H4";
      else {if (Period()== 1440)  C =C +  "   "+Symbol()+"   Daily";
      else {if (Period()== 10080) C =C +  " "+Symbol()+"   Weekly";
      else {if (Period()== 43200) C =C +  ""+Symbol()+"   Monthly"; }}}}}}}}                          
   ObjectCreate(item6, OBJ_LABEL, 0, 0, 0);
   ObjectSet(item6,OBJPROP_CORNER, 0);
   ObjectSet(item6,OBJPROP_XDISTANCE, 0);
   ObjectSet(item6,OBJPROP_YDISTANCE, p23);
   ObjectSet(item6, OBJPROP_COLOR, Symbol_And_TF_Color);         
   ObjectSetText(item6, C, 11, "Arial Bold");
                         
   //Spread
   Spread = MarketInfo(Symbol(), MODE_SPREAD);
   Spread = Spread/Factor;                                        
   ObjectCreate(item7, OBJ_LABEL, 0, 0, 0);
   ObjectSet(item7,OBJPROP_CORNER, 0);
   ObjectSet(item7,OBJPROP_XDISTANCE, p24);
   ObjectSet(item7,OBJPROP_YDISTANCE, p25);
   ObjectSet(item7, OBJPROP_COLOR, Spread_Color);         
   ObjectSetText(item7, "Spread   " + DoubleToStr(Spread,Digits_To_Show_In_Spread), p32, "Arial"); 
   
   //Range  
   Ranges(Days_For_Range_Average);
   Range = ((ARg/Days_For_Range_Average)/Point)/Factor; 
   ObjectCreate(item8, OBJ_LABEL, 0, 0, 0);
   ObjectSet(item8,OBJPROP_CORNER, 0);
   ObjectSet(item8,OBJPROP_XDISTANCE, p26);
   ObjectSet(item8,OBJPROP_YDISTANCE, p27);
   ObjectSet(item8, OBJPROP_COLOR, Range_Color);              
   ObjectSetText(item8, "Range    " +DoubleToStr(Range,0)+", "+DoubleToStr(TodayRange,0), 9, "Arial");           
                           
   //Time To Next Candle	   
   if (Period()>1440) {timeleft = " (OFF)";}
   else {timeleft =TimeToStr(Time[0]+Period()*60-TimeCurrent(),TIME_MINUTES|TIME_SECONDS);}                 
   ObjectCreate(item9, OBJ_LABEL, 0, 0, 0);
   ObjectSet(item9,OBJPROP_CORNER, 0);
   ObjectSet(item9,OBJPROP_XDISTANCE, p28);
   ObjectSet(item9,OBJPROP_YDISTANCE, p29);         
   ObjectSet(item9, OBJPROP_COLOR, Candle_Time_Color);        
   ObjectSetText(item9, "Candle   "+timeleft, p32, "Arial");          
      
   //Market Price  
   //Add leading spaces to center price labels
   tab="  "; tab2=" "; if ((Display_5_Digits_Forex) && (sub2 != "XA")) {tab=" "; tab2="";}                  
	     if(Symbol()== "USDMXN"){tab= tab2+"";}	   
   else if(Symbol()== "XAUUSD"){tab= tab2+"";} 	 	     	 
   else if(Symbol()== "USDJPY"){tab= tab2+"  ";}
	else if(Symbol()== "CHFJPY"){tab= tab2+"  ";}
	else if(Symbol()== "AUDJPY"){tab= tab2+"  ";}
	else if(Symbol()== "CADJPY"){tab= tab2+"  ";}
	else if(Symbol()== "XAGUSD"){tab= tab2+"  ";} 
   //Create/move label
   ObjectCreate(item10, OBJ_LABEL, 0, 0, 0);
   ObjectSet(item10,OBJPROP_CORNER, 0);
   ObjectSet(item10,OBJPROP_XDISTANCE, p30); 
   ObjectSet(item10,OBJPROP_YDISTANCE, p31); 
   ObjectSet(item10, OBJPROP_COLOR, Color);     
   ObjectSetText(item10, tab+Price, p33, "Verdana Bold"); 
   }//end Main Panel routine
     
   //Create SonicR Panel
   if((Main_Panel_On) && (__SonicR_Logo_On) && (Period()<= Main_Panel_Max_TF)) {
   //Create Sonic Panel Background boxes
   ObjectCreate(item3, OBJ_LABEL, 0, 0, 0, 0, 0);        
   ObjectSetText(item3,  "g", p1, "Webdings");      
   ObjectSet(item3, OBJPROP_CORNER, 0);
   ObjectSet(item3, OBJPROP_XDISTANCE, p2);
   ObjectSet(item3, OBJPROP_YDISTANCE, 0 );    
   ObjectSet(item3, OBJPROP_COLOR, Panel_Background_Color);         
   ObjectSet(item3, OBJPROP_BACK, false);
   //-----  
   ObjectCreate(item4, OBJ_LABEL, 0, 0, 0, 0, 0);        
   ObjectSetText(item4,  "g", p1, "Webdings");      
   ObjectSet(item4, OBJPROP_CORNER, 0);
   ObjectSet(item4, OBJPROP_XDISTANCE, p3);
   ObjectSet(item4, OBJPROP_YDISTANCE, 0 );    
   ObjectSet(item4, OBJPROP_COLOR, Panel_Background_Color);         
   ObjectSet(item4, OBJPROP_BACK, false); 
   
   //Create logo         
   ObjectDelete(item11);
   ObjectCreate(item11, OBJ_LABEL, 0, 0, 0);
   ObjectSet(item11,OBJPROP_CORNER, 0);
   ObjectSet(item11,OBJPROP_XDISTANCE, p4); 
   ObjectSet(item11,OBJPROP_YDISTANCE, p5);
   ObjectSet(item11, OBJPROP_COLOR, sonicS);  
   ObjectSetText(item11, "S", 16, "Verdana Bold");       
   //-----
   ObjectDelete(item12);
   ObjectCreate(item12, OBJ_LABEL, 0, 0, 0);
   ObjectSet(item12,OBJPROP_CORNER, 0);
   ObjectSet(item12,OBJPROP_XDISTANCE, p6); 
   ObjectSet(item12,OBJPROP_YDISTANCE, p7);
   ObjectSet(item12, OBJPROP_COLOR, sonicM);     
   ObjectSetText(item12, "o", 13, "Verdana Bold");    
   //-----
   ObjectDelete(item13);
   ObjectCreate(item13, OBJ_LABEL, 0, 0, 0);
   ObjectSet(item13,OBJPROP_CORNER, 0);
   ObjectSet(item13,OBJPROP_XDISTANCE, p8); 
   ObjectSet(item13,OBJPROP_YDISTANCE, p9);
   ObjectSet(item13, OBJPROP_COLOR, sonicM);     
   ObjectSetText(item13, "n", 13, "Verdana Bold");  
   //-----
   ObjectDelete(item14);
   ObjectCreate(item14, OBJ_LABEL, 0, 0, 0);
   ObjectSet(item14,OBJPROP_CORNER, 0);
   ObjectSet(item14,OBJPROP_XDISTANCE, p10); 
   ObjectSet(item14,OBJPROP_YDISTANCE, p11);
   ObjectSet(item14, OBJPROP_COLOR, sonicM);     
   ObjectSetText(item14, "i", 13, "Verdana Bold");       
   //-----
   ObjectDelete(item15);   
   ObjectCreate(item15, OBJ_LABEL, 0, 0, 0);
   ObjectSet(item15,OBJPROP_CORNER, 0);
   ObjectSet(item15,OBJPROP_XDISTANCE, p12); 
   ObjectSet(item15,OBJPROP_YDISTANCE, p13);
   ObjectSet(item15, OBJPROP_COLOR, sonicM);     
   ObjectSetText(item15, "c", 13, "Verdana Bold");      
   //-----
   ObjectDelete(item16);   
   ObjectCreate(item16, OBJ_LABEL, 0, 0, 0);
   ObjectSet(item16,OBJPROP_CORNER, 0);
   ObjectSet(item16,OBJPROP_XDISTANCE, p14); //p14=210
   ObjectSet(item16,OBJPROP_YDISTANCE, p15);
   ObjectSet(item16, OBJPROP_COLOR, sonicR);     
   ObjectSetText(item16, "R", 16, "Verdana Bold");
   }//end SonicR Panel routine 
     
   //Bid Line---------------------------------------------------------------------------------- 
   if (Bid_Line_On)
      {
      //Bid line
      T1=Time[0]+(Period()*60*Bid_Ray_TFs_Past_Last_Candle); 
      T2=iTime(NULL, NULL, (Period()*60)); 
                         
      if (ObjectFind(item17) != 0){
         ObjectCreate(item17, OBJ_TREND, 0, T1, Bid, T2, Bid);     
         ObjectSet(item17, OBJPROP_STYLE, Bid_Ray_LineStyle_01234 );
         ObjectSet(item17, OBJPROP_COLOR, Bid_Ray_Color);
         ObjectSet(item17, OBJPROP_WIDTH, Bid_Ray_Thickness);}  
      else{ 
         ObjectMove(item17, 0, T1, level);
         ObjectMove(item17, 1, T2, level);} 
       
      //Bid dot                   
      T1=Time[0]+(Period()*60*(Bid_Ray_TFs_Past_Last_Candle));   
      if (ObjectFind(item18) != 0){
         ObjectCreate(item18, OBJ_TREND, 0, T1, Bid, T1, Bid);     
         ObjectSet(item18, OBJPROP_STYLE, 0);
         ObjectSet(item18, OBJPROP_COLOR, Bid_Dot_Color);
         ObjectSet(item18, OBJPROP_WIDTH, Bid_Dot_Size);} 
      else{ 
         ObjectMove(item18, 0, T1, level);
         ObjectMove(item18, 1, T1, level);}                 
      }//End Bid Line

   //Levels------------------------------------------------------------------------------------
   if (Levels_On && Period()<= Levels_Max_TF)
      {      
      //initializing line colors
      Line1_Color = Whole_Number_Color; 
      Line2_Color = Half_Number_Color;
      Line3_Color = Quarter_Number_Color;
       
      //define needed variables
      ssp1= Bid / Poin;  //bid w/o the decimal
      c1=ssp1%100; //last two significant digits   
      BL=c1; //last two significant digits of starting/reference bid line  
       
      //calculate line levels bottom to top
      for (j= -(100-(100-BL))-(100*NumberOfRanges); j<= (100-BL)+(100*NumberOfRanges); j++)       
         {
         ssp=ssp1+j; 
         c1=ssp%100;        
         if (c1==u1)
            {           
            linestyle = Line1_Style_01234;
            linecolor = Line1_Color;
            linewidth = Line1_SolidThickness;
            linelevel = ssp*Poin;
            DrawLines("Levels", Level_Wholes_Display_Number, linelevel, linecolor, linestyle, linewidth);
            }
         if ((Half_Number_Lines_On) && (c1==u2))
            {              
            linestyle = Line2_Style_01234;
            linecolor = Line2_Color;
            linewidth = Line2_SolidThickness;
            linelevel = ssp*Poin;
            DrawLines("Levels", Level_Halves_Display_Number, linelevel, linecolor, linestyle, linewidth);
            } 
         if ((Quarter_Number_Lines_On) && ((c1==u3) || (c1==u4)))
            {           
            linestyle = Line3_Style_01234;
            linecolor = Line3_Color;
            linewidth = Line3_SolidThickness;
            linelevel = ssp*Poin;
            DrawLines("Levels", Level_Quarters_Display_Number, linelevel, linecolor, linestyle, linewidth);
            }
         }
      }//End Levels      
                    
   //Daily Pivot Lines------------------------------------------------------------------------- 
   if ((Pivots_DPV_Line_On) || (Pivots_DSR_Lines_On) && (Period()<= Pivots_Range_Lines_Max_TF))          
      {
      //Define yesterday's bar/data                    
      YesterdayBar   = iBarShift(NULL,PERIOD_D1,Time[0]-86400);
      YesterdayHigh  = iHigh(NULL,PERIOD_D1,YesterdayBar);
      YesterdayLow   = iLow(NULL,PERIOD_D1,YesterdayBar); 
      YesterdayClose = iClose(NULL,PERIOD_D1,YesterdayBar);        
      Pivot = (YesterdayHigh + YesterdayLow + YesterdayClose) /3; 
      
      if (Pivots_DSR_Lines_On)
         {       
         r5 = (4*Pivot)+(YesterdayHigh-(4*YesterdayLow));
         r4 = (3*Pivot)+(YesterdayHigh-(3*YesterdayLow));
         r3 = (2*Pivot)+(YesterdayHigh-(2*YesterdayLow));
         r2 = Pivot+(YesterdayHigh - YesterdayLow); 
         r1 = (2*Pivot)-YesterdayLow;  
         s1 = (2*Pivot)-YesterdayHigh;
         s2 = Pivot-(YesterdayHigh - YesterdayLow);  
         s3 = (2*Pivot)-((2* YesterdayHigh)-YesterdayLow);
         s4 = (3*Pivot)-((3* YesterdayHigh)-YesterdayLow);
         s5 = (4*Pivot)-((4* YesterdayHigh)-YesterdayLow);
         }             
      //Daily Central Pivot Line 
      if (Pivots_DPV_Line_On)
         {          
         //Pivot Line data to subroutine                                                              
         DrawLines("Pivot DPV1", Daily_PV_Line_Display_Number, Pivot, DPV1_Background_Color, DPV1_LineStyle_01234, DPV1_SolidLineThickness);
         DrawLines("Pivot DPV2", Daily_PV_Line_Display_Number, Pivot, DPV2_Top_Color, DPV2_LineStyle_01234, DPV2_SolidLineThickness);
         }
      //Daily Support & Resistance Lines   
      if (Pivots_DSR_Lines_On)
         {
         DrawLines("Pivot DR5", Daily_RS_Lines_Display_Number, r5, Resistance_Pivots_Color, R_LineStyle_01234, R_SolidLineThickness);  
         DrawLines("Pivot DR4", Daily_RS_Lines_Display_Number, r4, Resistance_Pivots_Color, R_LineStyle_01234, R_SolidLineThickness);   
         DrawLines("Pivot DR3", Daily_RS_Lines_Display_Number, r3, Resistance_Pivots_Color, R_LineStyle_01234, R_SolidLineThickness);   
         DrawLines("Pivot DR2", Daily_RS_Lines_Display_Number, r2, Resistance_Pivots_Color, R_LineStyle_01234, R_SolidLineThickness); 
         DrawLines("Pivot DR1", Daily_RS_Lines_Display_Number, r1, Resistance_Pivots_Color, R_LineStyle_01234, R_SolidLineThickness);   
         DrawLines("Pivot DS1", Daily_RS_Lines_Display_Number, s1, Support_Pivots_Color, S_LineStyle_01234, S_SolidLineThickness);
         DrawLines("Pivot DS2", Daily_RS_Lines_Display_Number, s2, Support_Pivots_Color, S_LineStyle_01234, S_SolidLineThickness);
         DrawLines("Pivot DS3", Daily_RS_Lines_Display_Number, s3, Support_Pivots_Color, S_LineStyle_01234, S_SolidLineThickness);  
         DrawLines("Pivot DS4", Daily_RS_Lines_Display_Number, s4, Support_Pivots_Color, S_LineStyle_01234, S_SolidLineThickness);
         DrawLines("Pivot DS5", Daily_RS_Lines_Display_Number, s5, Support_Pivots_Color, S_LineStyle_01234, S_SolidLineThickness);        
         }          
      }//End Daily Pivots
         
   //Range High/Low lines----------------------------------------------------------------------
   if (Range_Lines_On && Period()<= Pivots_Range_Lines_Max_TF)
      {         
      Ranges(Days_For_Range_Average);
      RangeAvg = NormalizeDouble(ARg/Days_For_Range_Average,4);                
      RangeHigh =  RangeAvg + iLow(NULL,PERIOD_D1,TodayBar);  //Comment(RangeHigh);
      RangeLow  = -RangeAvg + iHigh(NULL,PERIOD_D1,TodayBar); 

      if (HiToday - LoToday > RangeAvg)
         {            
         if (Bid >= HiToday- (HiToday-LoToday)/2) {RangeHigh = LoToday + RangeAvg; RangeLow  = LoToday;}
         else {RangeHigh  = HiToday; RangeLow = HiToday - RangeAvg;}
         }
             
      //Range Lines data to subroutine                                                             
      DrawLines("RgH", Range_Lines_Display_Number, RangeHigh, RangeHigh_Color, RG_LineStyle_01234, RG_SolidLineThickness);   
      DrawLines("RgL", Range_Lines_Display_Number, RangeLow,  RangeLow_Color, RG_LineStyle_01234, RG_SolidLineThickness);
      }//End Ranges
     
   //Separators-------------------------------------------------------------------------------   
   if (Separators_On && Period() <= Separators_Max_TF) 
      {
      //Separators for Today and Tomorrow           
      CurrentSeparators("Today", Separators_Color, Separators_Style_01234, Separators_Solid_Thickness);          
      CurrentSeparators("Tomorrow", Separators_Color, Separators_Style_01234, Separators_Solid_Thickness);  
              
      //Separators for prior sessions 
      if (Prior_Days_To_Show_Separators > 0)
         {     
         //Calculate bars per session        
              if (Period()==1) {bps = 1440;}   
         else if (Period()==5) {bps = 288;}  
         else if (Period()==15){bps = 96;}    
         else if (Period()==30){bps = 48;}
         else if (Period()==60){bps = 24;}         
         //Define bar starting prior sessions display      
         shift = iBarShift(NULL,NULL,iTime(NULL,PERIOD_D1,1));                       
         //Execute loop for bars per session X number of prior sessions to show   
         for (i= shift; i<=(shift+(bps*(Prior_Days_To_Show_Separators-1))); i++)       
            {  
            h=TimeHour(Time[i]); 
            m=TimeMinute(Time[i]);   
            if (h==0 && m==0)         
               {                     
               PriorSeparators(i, Separators_Color, 
               Separators_Style_01234, Separators_Solid_Thickness);                             
               }         
            }
         }
      }//end Separators   

   //vLines------------------------------------------------------------------------------------
   if (vLines_On && Period()<= vLines_Max_TF)
      {            
      //Start - Added by CaveMan/modified by TAH to cater for DST
      //Code will only check for DST on every new hour bar
      if(TimeHour(iTime(NULL,0,0)) == 0) LastRefresh = -1; // to cater for crossover into a new day
      if(First_Time || TimeHour(iTime(NULL,0,0)) > LastRefresh)
         {
         
         if (Adjust_for_DST()) 
            {
            Print(" TzPivot - Daylight Savings Time (DST) is in effect.");           
            //dst = 0;
            }           
         //During the non-DST time of the year, some vLine events occur an hour later relative
         //to GMT, than they do during DST.  For example, for a GMT based server the London
         //DST start time occurs at 7am GMT, but it occurs at 8am GMT during non-DST, an hour
         //later.  Therefore, at the shift from DST to non-DST, an hour must be added to the
         //start times of certain events to make their vLine occur an hour later on a GMT based 
         //chart.  This has nothing to do with the BrokerServer_GMToffset, or changes to it at
         //DST-nonDST changeovers.  The variable "dst" is used as a component of the start time
         //for those certain vLine events that require it.  
         //else {dst = 1;}                    
         First_Time = false; LastRefresh = TimeHour(iTime(NULL,0,0));
         }
      
      //Calculate position for vline labels----------------------------------------------------  
      if (vLabels_Dist_To_Border < 1) {vLabels_Dist_To_Border = 1;}            
      top = WindowPriceMax();
      bottom = WindowPriceMin();
      scale = top - bottom;            
      YadjustTop = scale/(9000/vLabels_FontSize);      
      YadjustTop = YadjustTop + (vLabels_Dist_To_Border * YadjustTop);      
      YadjustBot = scale/(500/vLabels_FontSize); 
      YadjustBot = YadjustBot + ((vLabels_Dist_To_Border * YadjustBot)/20);                  	      	
      level = top - YadjustTop; level = level;                 
      if (!vLabels_Chart_Top) {level = bottom + YadjustBot;}       
            
      //Do vlines for current session----------------------------------------------------------
      if (vLines_Current_Session_On) 
         {   
         OpenToday(Label_London_Open, GMT_At_DST_London_Open_Time + Current_Server_GMToffset + LondonDSTshift, vLines_Color, 
         vLines_Style_01234, vLines_Solid_Thickness, level);
            
         OpenToday(Label_NewYork_Open, GMT_At_NewYork_Open_Time + Current_Server_GMToffset + NewYorkDSTshift, vLines_Color, 
         vLines_Style_01234, vLines_Solid_Thickness, level);
        
         OpenToday(Label_London_Close, GMT_At_London_Close_Time + Current_Server_GMToffset + LondonDSTshift, vLines_Color, 
         vLines_Style_01234, vLines_Solid_Thickness, level);        
         }//End vLines current session
                    
      //Do vlines for previous sessions--------------------------------------------------------   
      if (vLines_Prior_Sessions_To_Show >0) 
         {   
         //Calculate bars per session----------------------------------------------------------        
              if (Period()==1) {bps = 1440;}   
         else if (Period()==5) {bps = 288;}  
         else if (Period()==15){bps = 96;}    
         else if (Period()==30){bps = 48;}
         else if (Period()==60){bps = 24;}         
         //Define bar starting prior sessions display------------------------------------------      
         shift = iBarShift(NULL,NULL,iTime(NULL,PERIOD_D1,0));               
         //Execute loop for bars per session X number of prior sessions to show----------------    
         for (i= shift; i<=(shift+(bps*(vLines_Prior_Sessions_To_Show))); i++)       
            {  
            h=TimeHour(Time[i]); 
            m=TimeMinute(Time[i]); 
            //London Open vLine
            if(GMT_At_DST_London_Open_Time+Current_Server_GMToffset<0) {GMT_At_DST_London_Open_Time=GMT_At_DST_London_Open_Time+24;}                
            MF = MathFloor(GMT_At_DST_London_Open_Time); 
            if((Period() > 30) && (h == MF + Current_Server_GMToffset+ LondonDSTshift) && (m == 0))                
               {
               OpenPrior(i, Label_London_Open, vLines_Color, vLines_Style_01234, vLines_Solid_Thickness, level);
               }               
            else if((GMT_At_DST_London_Open_Time != MF) && (h == MF + Current_Server_GMToffset+ LondonDSTshift) && (m == 30)) 
               {                    
               OpenPrior(i, Label_London_Open, vLines_Color, vLines_Style_01234, vLines_Solid_Thickness, level);
               }                   
            else if((GMT_At_DST_London_Open_Time == MF) && (h == MF + Current_Server_GMToffset+ LondonDSTshift) && (m == 0))
               {
               OpenPrior(i, Label_London_Open, vLines_Color, vLines_Style_01234, vLines_Solid_Thickness, level);
               }          
            //NewYork Open vLine             
            if(GMT_At_NewYork_Open_Time+Current_Server_GMToffset<0) {GMT_At_NewYork_Open_Time=GMT_At_NewYork_Open_Time+24;}                
            MF = MathFloor(GMT_At_NewYork_Open_Time); 
            if((Period() > 30) && (h == MF + Current_Server_GMToffset+ NewYorkDSTshift) && (m == 0))                
               {
               OpenPrior(i, Label_NewYork_Open, vLines_Color, vLines_Style_01234, vLines_Solid_Thickness, level);
               }                  
            else if((GMT_At_NewYork_Open_Time != MF) && (h == MF + Current_Server_GMToffset+ NewYorkDSTshift) && (m == 30)) 
               {                    
               OpenPrior(i, Label_NewYork_Open, vLines_Color, vLines_Style_01234, vLines_Solid_Thickness, level);
               }                   
            else if((GMT_At_NewYork_Open_Time == MF) && (h == MF + Current_Server_GMToffset+ NewYorkDSTshift) && (m == 0))               
               {
               OpenPrior(i, Label_NewYork_Open, vLines_Color, vLines_Style_01234, vLines_Solid_Thickness, level);
               }
            //London Close vLine           
            if(GMT_At_London_Close_Time+Current_Server_GMToffset<0) {GMT_At_London_Close_Time=GMT_At_London_Close_Time+24;}                                                      
            MF = MathFloor(GMT_At_London_Close_Time); 
            if((Period() > 30) && (h == MF + Current_Server_GMToffset+ LondonDSTshift) && (m == 0))                
               {
               OpenPrior(i, Label_London_Close, vLines_Color, vLines_Style_01234, vLines_Solid_Thickness, level);
               }                   
            else if((GMT_At_London_Close_Time != MF) && (h == MF + Current_Server_GMToffset+ LondonDSTshift) && (m == 30)) 
               {                    
               OpenPrior(i, Label_London_Close, vLines_Color, vLines_Style_01234, vLines_Solid_Thickness, level);
               }                   
            else if((GMT_At_London_Close_Time == MF) && (h == MF + Current_Server_GMToffset+ LondonDSTshift) && (m == 0))               
               {
               OpenPrior(i, Label_London_Close, vLines_Color, vLines_Style_01234, vLines_Solid_Thickness, level);
               }                                            
            }//end prior sessions shift loop                            
         }//end prior sessions routine                          
      }//end vLines routine
  
   //End of program computations---------------------------------------------------------------        
   return(0);
   }

//+-------------------------------------------------------------------------------------------+
//| Indicator Subroutine To Compute Average Ranges                                            |                                                 
//+-------------------------------------------------------------------------------------------+ 
void Ranges (int period)
   {
   int ii, iii, x, xx;
   //Add ranges over period.  Count number of Sundays and exclude Sunday ranges.         
   ARg = 0; for(i=1; i<=Days_For_Range_Average; i++)
       {
       if (TimeDayOfWeek(iTime(NULL,PERIOD_D1,i))!=0) {
       ARg = ARg + iHigh(NULL,PERIOD_D1,i)- iLow(NULL,PERIOD_D1,i);}
       else {x=x+1;}
       }
   //For number of Sundays, add additional days of range
   for(ii=i+1; ii<i+x+1; ii++) 
       {
       if (TimeDayOfWeek(iTime(NULL,PERIOD_D1,ii))!=0) {       
       ARg = ARg + iHigh(NULL,PERIOD_D1,ii)- iLow(NULL,PERIOD_D1,ii);}
       else {xx=xx+1;}       
       }      
   //If a Sunday reduced added days above, add additional day of range
   for(iii=ii+1; iii<ii+xx+1; iii++) 
       {
       ARg = ARg + iHigh(NULL,PERIOD_D1,iii)- iLow(NULL,PERIOD_D1,iii);
       }                     
   //Return total of ranges for period (Sundays excluded/additional days subsituted)
   return (ARg);   
   }
  
//+-------------------------------------------------------------------------------------------+
//| Subroutine To name and draw Daily Pivot and Range HL lines and line labels                |                                                                                  |
//+-------------------------------------------------------------------------------------------+
void DrawLines(string text, int Line_Selection_Number, double level, color Color, int linestyle, int thickness)
   {
   //Lines=====================================================================================  
   //Name lines 
   text = StringTrimLeft(text);       
   line = "[Chart Panel]  " + text + " Line " + level;  

   //Define variables  
   a = linestyle; b = thickness; c =1; if (a==0)c=b;  
   
   //Where to Start lines
   if ((Line_Selection_Number == 0) || (Line_Selection_Number == 1)) {startline = WindowFirstVisibleBar();} //start chart left
   else if(Line_Selection_Number == 2 || Line_Selection_Number == 3) {startline = iTime(NULL, PERIOD_D1, 0);} //start at day separator                  
   else if(Line_Selection_Number == 4) {T4 = Time[0]+ (Period()*60*Display_4_Shift_Right); startline  = T4;} //start right of last candle
                                                                   
   //Where to Stop Lines   
   if(Line_Selection_Number == 0 || Line_Selection_Number == 3) {stopline = Time[0]; R2 = true;}
   else if(Line_Selection_Number == 4) {stopline = T4 + 86400; R2 = true;}   
   else if ((Line_Selection_Number == 1) || (Line_Selection_Number == 2)) {stopline = iTime(NULL,PERIOD_D1,0)+86400; R2 = false;}
                       
   //Draw lines 
   if (ObjectFind(line) != 0)
      {
      ObjectCreate(line, OBJ_TREND, 0, startline, level, stopline, level);    
      ObjectSet(line, OBJPROP_STYLE, a);
      ObjectSet(line, OBJPROP_COLOR, Color);
      ObjectSet(line, OBJPROP_WIDTH, c);
      ObjectSet(line, OBJPROP_BACK, true); 
      ObjectSet(line, OBJPROP_RAY, R2);
      }
   else
      {
      ObjectMove(line, 0, startline, level);
      ObjectMove(line, 1, stopline, level);
      }
   
   //Labels===================================================================================
   //Exit if label not to be shown 
   if (text == "Levels") {return (-1);}          
   else if ((!DPV_Label_Shown) && (StringSubstr(text, 6, 3) == "DPV")) {return (-1);}
   else if ((!DSR_Labels_Shown) && ((StringSubstr(text, 6, 2) == "DR") || (StringSubstr(text, 6, 2) == "DS"))) {return (-1);} 
   else if ((!RG_Labels_Shown) && (StringSubstr(text, 0, 2) == "Rg")) {return (-1);} 
   else 
      {      
      //Name label,define price and add price to label if required        
      linelabel = "[Chart Panel]  " + StringTrimLeft(text) + " Label";
      //Remove "Pivot" from displayed pivots labels     
      if (StringSubstr(text, 0, 6) == "Pivot ") {text = StringSubstr(text, 6, 3);}
      
      if (Pivot_Range_Labels_Prices && StrToInteger(text)==0)       
         {
         if (Use_For_Forex) {Price=DoubleToStr(level, fxDigits);}
         else {Price=DoubleToStr(level, Digits);}
         //Align labels to be same as in SonicR TzPivots indicator
         text = "            " +text + "  " + Price; 
         }   
        
      //Where to put labels                          
      if (Pivot_Range_Labels_MaxRight) //start Max Right
         {
         spc="                                        "; //40
         startlabel = Time[0];    
         }
      //else if (Line_Selection_Number == 1) //start mid chart
      else if ((Line_Selection_Number == 0) || (Line_Selection_Number == 1)) //start mid chart
         {
         spc = ""; //00 
         startlabel = Time[WindowFirstVisibleBar()/2];
         }             
      else if (Line_Selection_Number == 2 || Line_Selection_Number == 3)            
         if (Time[WindowFirstVisibleBar()] < iTime(NULL, PERIOD_D1, 0)) //start at day separator
            {
            spc="       "; //07                           
            startlabel= iTime(NULL, PERIOD_D1, 0);  
            }          
         else //start start mid chart     
            {
         spc = ""; //00  
         startlabel = Time[WindowFirstVisibleBar()/2];                         
            }                        
      else if (Line_Selection_Number == 4) //start at current candle   
         {
         spc="         "; //09                   
         startlabel = T4;          
         }
                                     
      //Draw labels                            
      if (ObjectFind(linelabel) != 0)
         {
         ObjectCreate(linelabel, OBJ_TEXT, 0, startlabel, level);     
         ObjectSetText(linelabel, spc + text, Pivot_Range_Labels_FontSize, Pivot_Range_Labels_FontStyle, Pivot_Range_Labels_Color);
         ObjectSet(linelabel, OBJPROP_BACK, false);
         }        
      else {ObjectMove(linelabel, 0, startlabel, level);}       
      }
   }
   
//+-------------------------------------------------------------------------------------------+
//| Subroutine to Create Today and Tomorrow Separators                                        |          
//+-------------------------------------------------------------------------------------------+   
void CurrentSeparators(string text, color Color, int linestyle, int thickness) 
   {
   a = linestyle;
   b = thickness;
   c =1; if (a==0)c=b; 
      
   //Define datetime for start of current session vline separator
   if(text == "Today")       
      { 
      dt= TimeYear(iTime(NULL,0,0))+ "." +TimeMonth(iTime(NULL,0,0))+ "." + TimeDay(iTime(NULL,PERIOD_D1,0))+ "." + 0 + ":" + "0";                                        
      T3 = StrToTime(dt)+60;            
      vline  = "[Chart Panel] Today Session Line";     
      } 
      
   //Define datetime for end of current session vline separator
   else                
      {
      dt= TimeYear(iTime(NULL,0,0))+ "." +TimeMonth(iTime(NULL,0,0))+ "." + TimeDay(iTime(NULL,PERIOD_D1,0))+ "." + 24 + ":" + "60";                                        
      T3 = StrToTime(dt)+60;              
      vline  = "[Chart Panel] Tomorrow Session Line";            
      }
                        
   if (ObjectFind(vline) != 0){
      if(!Separators_Thru_SubWindows) {ObjectCreate(vline, OBJ_TREND, 0, T3, 0, T3, 100);}  
      else {ObjectCreate(vline, OBJ_VLINE, 0, T3, 0);}
      ObjectSet(vline, OBJPROP_STYLE, a);    
      ObjectSet(vline, OBJPROP_WIDTH, c);
      ObjectSet(vline, OBJPROP_COLOR, Color);
      ObjectSet(vline, OBJPROP_BACK, true); }
   else{
      ObjectMove(vline, 0, T3, 0);} 
   }
      
//+-------------------------------------------------------------------------------------------+
//| Subroutine to Create Prior Sessions Separators                                            |          
//+-------------------------------------------------------------------------------------------+   
void PriorSeparators(int i, color Color, int linestyle, int thickness)
   {
   a = linestyle;
   b = thickness;
   c =1; if (a==0)c=b;   
   vline  = "[Chart Panel] Prior Session  Line " + (i-1);       
                                 
   if (ObjectFind(vline) != 0){ 
      if(!Separators_Thru_SubWindows) {ObjectCreate(vline, OBJ_TREND, 0, Time[i], 0, Time[i], 100);} 
      else {ObjectCreate(vline, OBJ_VLINE, 0, Time[i], 0);}     
      ObjectSet(vline, OBJPROP_STYLE, a);    
      ObjectSet(vline, OBJPROP_WIDTH, c);
      ObjectSet(vline, OBJPROP_COLOR, Color);
      ObjectSet(vline, OBJPROP_BACK, true); }
   else{
      ObjectMove(vline, 0, Time[i], 0);} 
   }  

//+-------------------------------------------------------------------------------------------+
//| Subroutine to Create Market Open Lines And Labels For Current Session                     |          
//+-------------------------------------------------------------------------------------------+   
void OpenToday(string text, double time, color Color, int linestyle, int thickness, double level) 
   {
   vline  = "[Chart Panel]  " + StringTrimLeft(text) + " Current Session Line";    
   vlabel = "[Chart Panel]  " + StringTrimLeft(text) + " Current Session Label";  

   a = linestyle;
   b = thickness;
   c =1; if (a==0)c=b;
   
   time2 = time;
   if(time2<0) {time2 = time2 + 24;}
   time3 = MathFloor(time2);             
   dt= TimeYear(iTime(NULL,0,0))+ "." +TimeMonth(iTime(NULL,0,0))+ "." + TimeDay(iTime(NULL,1440,0))+ "." +time3+":"+"00";           
   time4 = StrToTime(dt);      
   if(time2 != time3) {time4 = time4 + 1800;}  //add half hour  
                             
   if (ObjectFind(vline) != 0){
      if(!vLines_Thru_SubWindows) {ObjectCreate(vline, OBJ_TREND, 0, time4, 0, time4, 100);}  
      else {ObjectCreate(vline, OBJ_VLINE, 0, time4, 0);}
      ObjectSet(vline, OBJPROP_STYLE, a);    
      ObjectSet(vline, OBJPROP_WIDTH, c);
      ObjectSet(vline, OBJPROP_COLOR, Color);
      ObjectSet(vline, OBJPROP_BACK, true); }
   else{
      ObjectMove(vline, 0, time4, 0);} 

   if ((!text == "day") && (!text == "day ")) {                                
   if (ObjectFind(vlabel) != 0) {
      ObjectCreate (vlabel, OBJ_TEXT, 0, time4, level);
      ObjectSetText(vlabel, text, vLabels_FontSize, vLabels_FontStyle, vLabels_Color);
      ObjectSet(vlabel, OBJPROP_BACK, false);}       
   else{ObjectMove(vlabel, 0, time4, level);}  }
   }
   
//+-------------------------------------------------------------------------------------------+
//| Subroutine to Create Market Open Lines And Labels For Prior Sessions                      |          
//+-------------------------------------------------------------------------------------------+   
void OpenPrior(int i, string text, color Color, int linestyle, int thickness, double level) 
   {   
   vline  = "[Chart Panel]  " + StringTrimLeft(text) + " Prior Session  " + (i-1) + " Line";    
   vlabel = "[Chart Panel]  " + StringTrimLeft(text) + " Prior Session  " + (i-1) + " Label"; 

   a = linestyle;
   b = thickness;
   c =1; if (a==0)c=b;
                                 
   if (ObjectFind(vline) != 0){ 
      if(!vLines_Thru_SubWindows) {ObjectCreate(vline, OBJ_TREND, 0, Time[i], 0, Time[i], 100);} 
      else {ObjectCreate(vline, OBJ_VLINE, 0, Time[i], 0);}     
      ObjectSet(vline, OBJPROP_STYLE, a);    
      ObjectSet(vline, OBJPROP_WIDTH, c);
      ObjectSet(vline, OBJPROP_COLOR, Color);
      ObjectSet(vline, OBJPROP_BACK, true); }
   else{
      ObjectMove(vline, 0, Time[i], 0);}
                                       
   if (ObjectFind(vlabel) != 0) {
      ObjectCreate (vlabel, OBJ_TEXT, 0, Time[i], level);
      ObjectSetText(vlabel, text, vLabels_FontSize, vLabels_FontStyle, vLabels_Color);
      ObjectSet(vlabel, OBJPROP_BACK, false);}       
   else{ObjectMove(vlabel, 0, Time[i], level);}    
   }
   
// Start - Added by CaveMan and modified by Traderathome to cater for DST
//+-------------------------------------------------------------------------------------------+
//| Calculate and return actual date given which Sunday of the month information              |
//+-------------------------------------------------------------------------------------------+
bool Adjust_for_DST()
   {
   // This definition section can be made into extern for user configuration but not neccesary.
   string Instructions1       = "Enter which Sunday of the month";
   string Instructions2       = "DST should start and end.";
   string Instructions3       = "1,2,3,4,5,6 = 1st, 2nd, 3rd, 4th, 5th and 6th";
   string Instructions4       = "7 = Last Sundy of the month";
  
   int us_dst_month_start     = 3;        // March
   int us_dst_start_sunday    = 2;        // 2nd Sunday of March start DST     
   string us_dst_time_start   = "02:00";  // DST starting time
   int us_dst_month_end       = 11;       // November   
   int us_dst_end_sunday      = 1;        // 1st Sunday of November end DST   
   string us_dst_time_end     = "02:00";  // DST ending time
 
   int eu_dst_month_start     = 3;        // March
   int eu_dst_start_sunday    = 7;        // Last Sunday of March start DST  
   string eu_dst_time_start   = "02:00";  // DST starting time
   int eu_dst_month_end       = 10;       // October
   int eu_dst_end_sunday      = 7;        // Last Sunday of October end DST   
   string eu_dst_time_end     = "02:00";  // DST ending time

   int aus_dst_month_start    = 4;        // April
   int aus_dst_start_sunday   = 1;        // 1st Sunday of April start DST   
   string aus_dst_time_start  = "02:00";  // DST starting time
   int aus_dst_month_end      = 10;       // October
   int aus_dst_end_sunday     = 1;        // 1st Sunday of October end DST   
   string aus_dst_time_end    = "02:00";  // DST ending time

   int nz_dst_month_start     = 4;        // April
   int nz_dst_start_sunday    = 1;        // 1st Sunday of April start DST  
   string nz_dst_time_start   = "02:00";  // DST starting time
   int nz_dst_month_end       = 9;        // September
   int nz_dst_end_sunday      = 7;        // Last Sunday of September end DST   
   string nz_dst_time_end     = "02:00";  // DST ending time

   datetime us_dst_start,   us_dst_end;   // dst start and end datetime
   datetime eu_dst_start,   eu_dst_end; 
   datetime aus_dst_start, aus_dst_end; 
   datetime nz_dst_start,   nz_dst_end; 
   datetime cus_dst_start, cus_dst_end; 
      
   int cus_dst_month_start   = Custom_DST_Start_Month;
   int cus_dst_start_sunday  = Custom_DST_Start_Sunday;
   string cus_dst_time_start = Custom_DST_Start_Time;
   int cus_dst_month_end     =  Custom_DST_End_Month;   
   int cus_dst_end_sunday    = Custom_DST_End_Sunday;
   string cus_dst_time_end   =  Custom_DST_End_Time;  
   
   //Print("US DST Start/End Date = ", TimeToStr(us_dst_start), " / ", TimeToStr(us_dst_end));
   //Print("EU DST Start/End Date = ", TimeToStr(eu_dst_start), " / ", TimeToStr(eu_dst_end));
      
   us_dst_start  = check_date(us_dst_start_sunday,  us_dst_month_start,  us_dst_time_start);
   us_dst_end    = check_date(us_dst_end_sunday,    us_dst_month_end,    us_dst_time_end);
   eu_dst_start  = check_date(eu_dst_start_sunday,  eu_dst_month_start,  eu_dst_time_start);
   eu_dst_end    = check_date(eu_dst_end_sunday,    eu_dst_month_end,    eu_dst_time_end);
   aus_dst_start = check_date(aus_dst_start_sunday, aus_dst_month_start, aus_dst_time_start);
   aus_dst_end   = check_date(aus_dst_end_sunday,   aus_dst_month_end,   aus_dst_time_end);
   nz_dst_start  = check_date(nz_dst_start_sunday,  nz_dst_month_start,  nz_dst_time_start);
   nz_dst_end    = check_date(nz_dst_end_sunday,    nz_dst_month_end,    nz_dst_time_end);
   cus_dst_start = check_date(cus_dst_start_sunday, cus_dst_month_start, cus_dst_time_start);
   cus_dst_end   = check_date(cus_dst_end_sunday,   cus_dst_month_end,   cus_dst_time_end);

//Start Traderathome modification- 
   //Independently shift London and NY vLines to an hour later when London and NY separately 
   //implement their changeovers from DST to nonDST. 
   LondonDSTshift = 0;
   NewYorkDSTshift = 0;     
   if (iTime(NULL,0,0) > eu_dst_end && iTime(NULL,0,0) < eu_dst_start)  {LondonDSTshift = 1;}
   if (iTime(NULL,0,0) > us_dst_end && iTime(NULL,0,0) < us_dst_start) {NewYorkDSTshift = 1;}
//End Traderathome modification-

   //Determine when to simultaneously shift all vLines due to the broker server making the 
   //changeover from DST to nonDST (i.e., change GMT offset for broker server)
   if (DST_Zone == 1 && iTime(NULL,0,0) > us_dst_start && iTime(NULL,0,0) < us_dst_end)
      {
      Current_Server_GMToffset = DST_Server_GMT_Offset; 
      return(true);
      }
   else if (DST_Zone == 2 && iTime(NULL,0,0) > eu_dst_start && iTime(NULL,0,0) < eu_dst_end)
      { 
      Current_Server_GMToffset = DST_Server_GMT_Offset;      
      return(true);
      }
   else if (DST_Zone == 3 && iTime(NULL,0,0) > aus_dst_start && iTime(NULL,0,0) < aus_dst_end)
      {
      Current_Server_GMToffset = DST_Server_GMT_Offset; 
      return(true);
      }
   else if (DST_Zone == 4 && iTime(NULL,0,0) > nz_dst_start && iTime(NULL,0,0) < nz_dst_end)
      {
      Current_Server_GMToffset = DST_Server_GMT_Offset; 
      return(true);
      }
   else if (DST_Zone == 5 && iTime(NULL,0,0) > cus_dst_start && iTime(NULL,0,0) < cus_dst_end)
      {
      Current_Server_GMToffset = DST_Server_GMT_Offset; 
      return(true);
      }
   else
      {
      Current_Server_GMToffset = NonDST_Server_GMToffset; 
      return(false);
      }                
   }              

//+-------------------------------------------------------------------------------------------+
//| Calculate and return actual date given which Sunday of the month information              |
//+-------------------------------------------------------------------------------------------+
datetime check_date(int which_sunday, int which_month, string what_time)
{
   string start_date;
   int day_of_week, start_day;

   if (which_sunday == 7)  // Last Sunday of the month
      {
         for (int i = 31; i > 20; i--)
            {
               start_date = TimeYear(iTime(NULL,0,0)) + "." + which_month + "." + i;
               day_of_week = TimeDayOfWeek(StrToTime(start_date));
               if (day_of_week == 0) // equals to Sunday
                  {
                     start_date = TimeYear(iTime(NULL,0,0)) + "." + which_month + "." + i + " " + what_time;
                     break;
                   }
             } 
      }
   else // other Sundays of the month besides last Sunday of the month
      {
         start_date = TimeYear(iTime(NULL,0,0)) + "." + which_month + "." + "1";
         day_of_week = TimeDayOfWeek(StrToTime(start_date));
   
         if (day_of_week == 0) start_day = 1 + 7*(which_sunday - 1);
         else start_day = 1 + (7 - day_of_week) + 7 * (which_sunday - 1);
   
         start_date = TimeYear(iTime(NULL,0,0)) + "." + which_month + "." + start_day + " " + what_time;
      }
      
   return(StrToTime(start_date));
}
// End - Added by CaveMan to cater for DST

//+-------------------------------------------------------------------------------------------+
//| Indicator End                                                                             |                                                        
//+-------------------------------------------------------------------------------------------+      

